<%@ Assembly Name="inetsoftware.Pdfc" %><%-- the dll must be in the bin directory --%>
<%@ Import Namespace="inetsoftware.ProcessBridge" %>
<%@ Import Namespace="inetsoftware.Pdfc" %>
<%@ Import Namespace="inetsoftware.Pdfc.Presenter" %>
<%@ Import Namespace="inetsoftware.Pdfc.Results" %>
<%@ Import Namespace="System.IO" %>
<%@ Import Namespace="System.Web.Hosting" %>
<%@ Page Language="C#" Debug="true" %>
<script runat="server">
    protected void Page_Load(object sender, EventArgs e)
    {
        // redirect the ProcessBridge logging to a file
        /*if( !(ProcessConfig.ProcessConsole is StreamWriter) || !(((StreamWriter)ProcessConfig.ProcessConsole).BaseStream is FileStream) ) {
            StreamWriter logWriter = new StreamWriter( new FileStream( @"ConsoleOutput.txt", FileMode.Append, FileAccess.Write, FileShare.ReadWrite) );
            logWriter.AutoFlush = true;
            ProcessConfig.ProcessConsole = logWriter;
            logWriter.WriteLine( "Start logging to file" );
        }*/

        // set the log level to debug (4) permanently. Typical to file PDFCLog.txt.
        // inetsoftware.Config.ConfigurationManager.Instance.Current["log.levels"] = "{'PDFC':4, 'Config':4}";

        string scriptPath = HostingEnvironment.MapPath("~");
        string file1 = Path.GetFullPath(scriptPath + @"\..\resources\Example1.pdf");
        string file2 = Path.GetFullPath(scriptPath + @"\..\resources\Example2.pdf");

        string tempPdfFile = Path.GetTempFileName();
        var pdfComparer = new PDFComparer();
        pdfComparer.AddPresenter(new DifferencesPDFPresenter(tempPdfFile, false));

        using (ResultModel result = pdfComparer.Compare(file1, file1))
        {
            // int differences = result.GetDifferencesCount(false);
        }
        Response.BufferOutput = false;
        Response.ContentType = "Application/pdf";
        Response.TransmitFile(tempPdfFile);
        File.Delete(tempPdfFile);
    }
</script>